<?php
/**
 * 阅读文章页面
 */
defined('EM_ROOT') || exit('access denied!');
?>

<style>
    .goods-sku .label{
        font-size: 13px;
        padding: 6px 12px;
        margin-right: 5px;
        cursor: pointer;
        color: #5c5c5c;
        border-color: #F0F0F0;
        background: #F0F0F0;
        white-space: nowrap;
        margin-bottom: 12px;
        display: inline-block;
    }
    .goods-sku .label:hover{
        background: #E0E0E0;
    }

    .goods-attr .currency, .goods-attr .price{
        color: #ea644a;
        font-size: 14px;
    }

    .goods-attr .price{
        font-size: 28px;
    }

    .goods-attr .bh-sku-selected{
        color: #ea644a;
        border-color: #ea644a;
        background: #FFF7F3;
    }
    .goods-attr .bh-sku-selected:hover{
        color: #ea644a;
        border-color: #ea644a;
        background: #FFF7F3;
    }
    .goods-con .panel{
        border: none;
    }

    .label[disabled="disabled"]{
        background: #F0F0F0;
        opacity: 0.5; /* 降低透明度 */
    }
    .label[disabled="disabled"]:hover{
        background: #F0F0F0;
        opacity: 0.5; /* 降低透明度 */
        cursor: not-allowed; /* 改变鼠标光标样式 */
    }

    /*数量选择器 start*/
    /* 数量选择器整体样式 */
    .quantity-selector {
        display: inline-flex;
        align-items: center;
        gap: 8px; /* 标签和选择器间距 */
        margin: 10px 0;
    }

    /* 数量标签样式 */
    .quantity-label {
        font-size: 14px;
        color: #666;
        position: relative;
        top: -1px; /* 微调垂直对齐 */
    }

    /* 数量选择器容器 */
    .spinner {
        display: inline-flex;
        align-items: center;
        border: 1px solid #ddd;
        border-radius: 4px;
        overflow: hidden;
        background: #fff;
        box-shadow: 0 1px 2px rgba(0,0,0,0.05);
        height: 32px; /* 固定高度 */
    }

    /* 加减按钮通用样式 */
    .spinner .btn {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 100%;
        background: #f8f8f8;
        color: #666;
        font-size: 16px;
        font-weight: bold;
        cursor: pointer;
        user-select: none;
        transition: all 0.2s;
        border: none;
        outline: none;
    }

    /* 减号按钮 */
    .spinner .decrease {
        border-right: 1px solid #eee;
    }

    /* 加号按钮 */
    .spinner .increase {
        border-left: 1px solid #eee;
    }

    /* 按钮悬停效果 */
    .spinner .btn:hover {
        background: #eaeaea;
        color: #333;
    }

    /* 按钮点击效果 */
    .spinner .btn:active {
        background: #ddd;
    }

    /* 输入框样式 */
    .spinner .value {
        width: 40px;
        height: 100%;
        border: none;
        text-align: center;
        font-size: 14px;
        color: #333;
        padding: 0 5px;
        outline: none;
        -moz-appearance: textfield; /* 隐藏数字输入框的上下箭头 */
    }

    /* 隐藏数字输入框的上下箭头（Chrome/Safari） */
    .spinner .value::-webkit-outer-spin-button,
    .spinner .value::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }

    /* 输入框聚焦效果 */
    .spinner .value:focus {
        background: #f5f5f5;
    }
    /*数量选择器 end*/

    /* 售罄提示容器 start */
    /* 终极简约售罄提示 */
    .soldout-notice {
        padding: 18px;
        margin: 24px 0;
        background: #fafafa;
        border-left: 3px solid #e0e0e0;
        font-size: 15px;
        color: #555;
        display: flex;
        align-items: center;
        line-height: 1.5;
        position: relative;
    }

    /* 更克制的图标 */
    .soldout-icon {
        margin-right: 14px;
        color: #777;
        font-size: 20px;
        font-weight: 300;
    }

    /* 精致文字链接 */
    .soldout-link {
        color: #222;
        text-decoration: none;
        border-bottom: 1px solid #ccc;
        padding-bottom: 1px;
        margin-left: 6px;
        transition: all 0.2s ease;
    }

    .soldout-link:hover {
        text-decoration: none;
    }

    /* 极简动画 */
    .soldout-notice {
        transition: all 0.3s ease;
    }

    .soldout-notice:hover {
        background: #f5f5f5;
    }
    /*售罄提示容器 end*/

    .intro{
        overflow-wrap: break-word; /* 允许非单词边界的换行 */
        word-wrap: break-word;     /* 兼容旧版浏览器 */
        word-break: break-all; /* 强制在任意字符处换行 */
    }
    .intro img{
        max-width: 100%;
        height: auto;
    }
    .intro a {
        color: #007bff;
        text-decoration: none;
        background-color: transparent;
    }
    .intro a:hover {
        text-decoration: underline;
    }
</style>

<article class="container goods-con" style="margin-top: 85px;">

    <div class="card mb-3" style="">
        <div class="row no-gutters">
            <div class="col-md-4" style="padding: 10px;">
                <img class="goods-cover" src="<?= $goods['cover'] ?>" alt="" style="" />
            </div>
            <div class="col-md-8">
                <div class="card-body goods-attr">
                    <h3 class="card-title" style="font-size: 1.5rem;"><?= $goods['title'] ?></h3>
                    <p class="card-text">
                        <?php if(Option::get('sales_switch') == 'y'): ?>
                            <span class="text-muted">已售：<?= $goods['sales'] ?></>
                        <?php endif; ?>
                        <?php if(Option::get('stock_switch') == 'y'): ?>
                            <span class="text-muted ml-3">库存：<span id="stock"><?= $goods['stock'] ?></span></span>
                        <?php endif; ?>
                    </p>
                    <div style="margin-bottom: 15px;">
                        <span class="currency">¥</span>
                        <span class="price" id="price"></span>
                    </div>

                    <div class="col-lg-12" style="padding: 0;">
                        <?php if($goods['is_sku'] == 'y'): ?>
                            <div class="goods-sku">
                                <?php foreach($goods['spec'] as $val){ ?>
                                    <div style="margin-bottom: 15px;">
                                        <span><?php echo $val['title'] ?>：</span>
                                        <?php foreach($val['sku_values'] as $v){ ?>
                                            <span class="label label-outline sku" sku_value_id="<?php echo $v['id'] ?>"><?= $v['name'] ?></span>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php endif; ?>
                        <?php if($goods['stock'] > 0){ ?>
                            <div>
                                <form action="?action=confirm_order" method="post" id="form">

                                    <div class="quantity-selector">
                                        <span class="quantity-label">数量：</span>
                                        <div class="spinner">
                                            <span class="btn decrease" data-no="0">-</span>
                                            <input name="product[0][quantity]" id="quantity-0" type="number" class="value" maxlength="5" value="1">
                                            <span class="btn increase" data-no="0">+</span>
                                        </div>
                                    </div>
                                    <div style="clear: both; margin-bottom: 20px;"></div>
                                    <input name="product[0][goods_id]" type="hidden" value="<?= $goods_id ?>" />
                                    <input name="product[0][sku]" id="sku-input" type="hidden" />
                                    <!--                            <input type="button" value="加入购物车" id="add-cart-btn" />-->

                                    <input type="submit" value="立即购买" id="sku-buy-btn" class="btn btn-primary" />
                                    <input type="hidden" id="select-sku-status" value="0" />
                                </form>
                            </div>
                        <?php } ?>
                        <?php if($goods['stock'] <= 0){ ?>
                            <div class="soldout-notice">
                                <span>商品已售罄，<a href="/" class="soldout-link">去看看其他商品</a></span>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>





    <div class="card" style="padding: 15px;">
        <div class="markdown intro" id="emlogEchoLog"><?= $goods['content'] ?></div>
    </div>





    <div style="clear:both;"></div>
</article>



<script>
    var keys = <?php echo $goods['spec_attr_json'] ?>;
    var data = <?php echo $goods['have_stock_skus_json']; ?>;
    var goods_sku_all_json = <?php echo $goods['skus_all_json']; ?>;
</script>
<script src="../../content/common/js/sku.js?v=<?= $version ?>&t=<?= Option::EM_VERSION_TIMESTAMP ?>"></script>

<?php if($goods['is_sku'] == 'y'): ?>
<script>
    $('#sku-buy-btn').click(function(){
        if($('#select-sku-status').val() == 0){
            alert('请选择您要购买的商品信息');
            return false;
        }
        return true;
    })
</script>
<?php endif; ?>



<script>

    // 数量
    $('.decrease').click(function(){ // -
        var no = $(this).data('no');
        setQuantity(no, '-')
    })
    $('.increase').click(function(){ // +
        var no = $(this).data('no');
        setQuantity(no, '+');
    })

    function setQuantity(no, type){
        var quantity = $('#quantity-' + no).val();
        if(type == '+'){
            $('#quantity-' + no).val(Number(quantity) + 1);
        }else{
            if(quantity <= 1){
                $('#quantity-' + no).val(1);
            }else{
                $('#quantity-' + no).val(Number(quantity) - 1);
            }
        }
    }




    // 加入购物车
    $('#add-cart-btn').click(function(){

        if($('#select-sku-status').val() == 0){
            alert('请选择您要购买的商品信息');
            return false;
        }
        var params = $('#form').serializeArray();
        var api = "<?= EM_URL ?>?rest-api=add_cart";
        $.post(api, params, function(e){
            if(e.code == 200){
                alert('已加入购物车');
            }
        }, "json")
    })
</script>

<?php include View::getCommonView('footer') ?>
