<?php
/**
 * The productf management
 *
 * @package EMLOG
 * @link https://www.emlog.net
 */

/**
 * @var string $action
 * @var object $CACHE
 */

require_once 'globals.php';

$orderModel = new Order_Model();
$Sort_Model = new Sort_Model();
$User_Model = new User_Model();
$MediaSort_Model = new MediaSort_Model();
$Template_Model = new Template_Model();

// 订单列表
if (empty($action)) {
    $page = Input::getIntVar('page', 1);



    $br = '<a href="./">控制台</a><a href="./order.php">订单管理</a><a><cite>商品订单</cite></a>';

    include View::getAdmView(User::haveEditPermission() ? 'header' : 'uc_header');
    require_once View::getAdmView(User::haveEditPermission() ? 'order' : 'uc_order');
    include View::getAdmView(User::haveEditPermission() ? 'footer' : 'uc_footer');
    View::output();
}



if ($action == 'index') {

    $page = Input::getIntVar('page', 1);
    $limit = Input::getIntVar('limit', 10);
    $start = ($page - 1) * $limit;
    $sort1 = Input::getStrVar('field', 'uid');
    $sort2 = Input::getStrVar('order', 'desc');
    $order_by = "order by {$sort1} {$sort2}";


    $where  = [];
    $where['email_username'] = Input::getStrVar('email_username');
    $where['out_trade_no'] = Input::getStrVar('out_trade_no');
    $where['goods_title'] = Input::getStrVar('goods_title');
    $where['client_ip'] = Input::getStrVar('client_ip');
    $where['order_required'] = Input::getStrVar('order_required');

    $orderNum = $orderModel->getOrderNum($where);
    $order = $orderModel->getOrderForAdmin($start, $limit, $where);
    foreach($order as $key => $val){
        $order[$key]['pay_time'] = empty($val['pay_time']) ? '' : date('Y-m-d H:i:s', $val['pay_time']);
        $order[$key]['amount'] = number_format($val['amount'], 2);
    }
    output::data($order, $orderNum);
}

if($action == 'get_deliver'){
    $order_id = Input::getIntVar('order_id');
    $order_list_id = Input::getIntVar('order_list_id');
    $db = Database::getInstance();
    $sql = "select * from " . DB_PREFIX . "order where id={$order_id}";
    $order = $db->once_fetch_array($sql);
    $sql = "select * from " . DB_PREFIX . "deliver where order_list_id={$order_list_id} limit 5";
    $deliver = $db->fetch_all($sql);

    $order_deliver = "";
    if(empty($order['device'])){
        foreach($deliver as $val){
            if(!empty($order_deliver)){
                $order_deliver .= "<hr>";
            }
            $order_deliver .= $val['content'];
        }
    }else{
        $order_deliver = $order['device'];
    }
    $order_deliver = empty($order_deliver) ? '无' : $order_deliver;

    $sql = "select * from " . DB_PREFIX . "order_required where order_id={$order_id}";
    $order_required = $db->fetch_all($sql);

    $data = [
        'order_deliver' => $order_deliver,
        'order_required' => $order_required
    ];

    output::ok($data);

}

if($action == 'download'){
    $db = Database::getInstance();
    $db_prefix = DB_PREFIX;
    $goods_type = Input::getStrVar('goods_type');
    $order_list_id = Input::getIntVar('order_list_id');
    $func = "adm_download_deliver_content_{$goods_type}";


    if (function_exists($func)) {
        $func($db, $db_prefix, $order_list_id);
    }
}

// 补单
if($action == 'repay'){
	
//	LoginAuth::checkToken();
    $out_trade_no = Input::postStrVar('out_trade_no');
    $payController = new Pay_Controller();
    $payController->repay($out_trade_no);
    output::ok();
}

// 删除订单
if ($action == 'del') {

    $ids = Input::postStrVar('ids');

    $timestamp = time();
    $sql = "UPDATE " . DB_PREFIX . "order set delete_time={$timestamp} where id IN ({$ids})";

    $db = Database::getInstance();
    $db->query($sql);
    output::ok();

}

// 手动发货
if ($action == 'deliver_ajax') {
    $id = Input::postIntVar('id');
    LoginAuth::checkToken();
    $remark = Input::postStrVar('remark');
    $orderModel->handDeliver($id, $remark);
    output::ok();
}

if ($action == 'deliver') {
    $order_id = Input::getIntVar('order_id');
    $db = Database::getInstance();
    $db_prefix = DB_PREFIX;
    $order = $db->once_fetch_array("select * from {$db_prefix}order where id = {$order_id}");
    $child_order = $db->once_fetch_array("select * from {$db_prefix}order_list where order_id = {$order_id}");
    $goods = $db->once_fetch_array("select * from {$db_prefix}goods where id = {$child_order['goods_id']}");
    doAction('adm_deliver_view', $db, $db_prefix, $goods, $order, $child_order);
}

if ($action == 'detail') {
    $db = Database::getInstance();
    $db_prefix = DB_PREFIX;

    $order_id = Input::getIntVar('order_id');
    $sql = "SELECT * FROM `{$db_prefix}order` where id={$order_id}";
    $order = $db->once_fetch_array($sql);
    $order['amount'] = number_format($order['amount'] / 100, 2);
    $order['status'] = orderStatusText($order['status']);

    $sql = "SELECT * FROM `{$db_prefix}user` where uid={$order['user_id']}";
    $user = $db->once_fetch_array($sql);

    $sql = "SELECT * FROM `{$db_prefix}order_list` where order_id={$order['id']}";
    $order_list = $db->once_fetch_array($sql);
    $order_list['unit_price'] = number_format($order_list['unit_price'] / 100, 2);
    $order_list['attach_user'] = empty($order_list['attach_user']) ? '无' : $order_list['attach_user'];
    if(empty($order_list['attach_user'])){
        $order_list['attach_user'] = '无';
    }else{
        $attach_user = json_decode($order_list['attach_user'], true);
        $order_list['attach_user'] = '';
        if(empty($attach_user)){
            $order_list['attach_user'] = '无';
        }else{
            foreach($attach_user as $key => $val){
                $order_list['attach_user'] .= $key . '：' . $val . '；';
            }
        }


    }

    $sql = "SELECT * FROM `{$db_prefix}goods` where id={$order_list['goods_id']}";
    $goods = $db->once_fetch_array($sql);

    $sql = "SELECT * FROM `{$db_prefix}order_required` where order_id={$order_id}";
    $res = $db->fetch_all($sql);
    $order_required = '';
    if(empty($res)){
        $order_required = '无';
    }else{
        foreach($res as $val){
            $order_required .= $val['name'] . '：' . $val['content'] . '；';
        }
    }

    $data = [
        'db' => $db,
        'db_prefix' => $db_prefix,
        'goods' => $goods,
        'child_order' => $order_list,
    ];

    $fun = "plugin_goods_{$goods['type']}_adm_order_detail";

    $order_deliver = $fun($db, $db_prefix, $goods, $order_list);


    include View::getAdmView('open_head');
    require_once View::getAdmView('order_detail');
    include View::getAdmView('open_foot');
    View::output();
}