<?php
defined('EM_ROOT') || exit('access denied!');
?>
<table class="layui-hide" id="index" lay-filter="index"></table>
<script type="text/html" id="toolbar">
    <div class="layui-btn-container">
        <button class="layui-btn layui-btn-primary layui-border-green" lay-event="refresh">
            <i class="fa fa-refresh" style=""></i>
        </button>
        <button type="button" class="layui-btn layui-bg-blue" lay-event="store">应用商店</button>
    </div>
</script>
<script type="text/html" id="cover">
    <div class="layui-clear-space">
        <a href="javascript:;" data-id="{{ d.id }}" lay-event="img">
            <img onerror="this.onerror=null; this.src='./views/images/null.png'" class="cover" data-img="{{ d.preview }}" src="{{ d.preview }}" style="width: 40px; border-radius: 3px;" />
        </a>
    </div>
</script>

<script type="text/html" id="title">
    <div class="layui-clear-space">
        <span style="margin-left: 8px;">{{ d.tplname }}</span>
    </div>
</script>

<script type="text/html" id="switch">
    <input type="checkbox" name="{{= d.tplfile }}" value="{{= d.tplfile }}" title=" ON |OFF " lay-skin="switch" lay-filter="switch" {{= d.switch == 'y' ? "checked" : "" }}>
</script>

<script type="text/html" id="operate">
    <div class="layui-clear-space">
        {{#  if(d.update == 'y'){ }}
        <a class="layui-btn layui-bg-blue" lay-event="update">更新版本</a>
        {{#  } }}
        <a class="layui-btn" lay-event="setting">配置</a>
        <a class="layui-btn layui-bg-red" lay-event="del">删除</a>

    </div>
</script>


<script>
    layui.use(['table'], function(){
        var table = layui.table;
        var form = layui.form;
        // 创建渲染实例
        window.table = table.render({
            elem: '#index',
            autoSort: false,
            url: '?action=index', // 此处为静态模拟数据，实际使用时需换成真实接口
            toolbar: '#toolbar',
            limits: [10,20,30,50,100],
            page: false,
            lineStyle: 'height: 30px;',
            defaultToolbar: ['filter', 'exports', 'print', { // 右上角工具图标
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips',
                onClick: function(obj) { // 2.9.12+
                    layer.alert('自定义工具栏图标按钮');
                }
            }],


            cols: [[
                {field:'name', title:'图片', width: 80, templet: '#cover', align: 'center'},
                {field:'title', title:'模板名称', minWidth: 170, templet: '#title'},
                {field:'version', title:'版本号', width: 130, align: 'center' },
                {field:'switch', title:'启用', align: 'center', width: 100, templet: '#switch'},
                {title:'操作', templet: '#operate', width: 250, align: 'left'}
            ]],

            error: function(res, msg){
                console.log(res, msg)
            }
        });

        // 状态 - 开关操作
        form.on('switch(switch)', function(obj){
            var active = obj.elem.checked == true ? 1 : 0;
            var tpl = this.name;

            if(active == 0){
                tpl = 'em_null_tpl';
            }
            var loadSwitch = layer.load(2);
            $.ajax({
                url: '?action=use',
                type: 'POST',
                dataType: 'json',
                data: { tpl: tpl, status: active, token: '<?= LoginAuth::genToken() ?>' },
                success: function(res) {
                    layer.msg('操作成功');
                    table.reload('index');
                },
                error: function(err) {
                    layer.msg(err.responseJSON.msg);
                },
                complete: function() {
                    layer.close(loadSwitch);
                }
            });
        });


        // 工具栏事件
        table.on('toolbar(index)', function(obj){
            var id = obj.config.id;
            var checkStatus = table.checkStatus(id);
            var othis = lay(this);
            if(obj.event == 'refresh'){
                table.reload(id);
            }
            if(obj.event == 'store'){
                location.href="store.php?action=tpl"
            }

        });

        // 触发单元格工具事件
        table.on('tool(index)', function(obj){ // 双击 toolDouble
            var data = obj.data; // 获得当前行数据
            var id = obj.config.id;
            if(obj.event == 'del'){
                layer.confirm('确定删除？', {
                    btn: ['确认', '取消'], // 按钮
                    icon: 3,             // 图标，3表示问号
                    title: '温馨提示'
                }, function(index) {
                    layer.close(index); // 关闭对话框
                    $.ajax({
                        url: '?action=del',
                        type: 'POST',
                        dataType: 'json',
                        data: { ids: data.tplfile, token: '<?= LoginAuth::genToken() ?>' },
                        success: function(res) {
                            layer.msg('删除成功');
                            table.reload(id);
                        },
                        error: function(err) {
                            layer.msg(err.responseJSON.msg);
                        }
                    });
                });
            }

            if(obj.event === 'img'){
                layer.photos({
                    photos: {
                        "title": data.title,
                        "start": 0,
                        "data": [
                            {
                                "alt": data.tplname,
                                "pid": 1,
                                "src": data.preview,
                            }
                        ]
                    }
                });
            }
            if(obj.event === 'update'){
            // ./template.php?action=upgrade&alias=" + item.name
                var loadSwitch = layer.load(2);
                $.ajax({
                    url: '?action=upgrade',
                    type: 'POST',
                    dataType: 'json',
                    data: { alias: data.tplfile, token: '<?= LoginAuth::genToken() ?>' },
                    success: function(res) {
                        layer.msg('更新成功');
                        table.reload(id);
                    },
                    error: function(err) {
                        layer.msg(err.responseJSON.msg);
                    },
                    complete: function() {
                        layer.close(loadSwitch);
                    }
                });

            }
            if(obj.event === 'setting'){
                let isMobile = window.innerWidth < 1200;
                let area = isMobile ? ['98%', '85%']  : ['1000px', '800px'];
                layer.open({
                    id: 'setting',
                    title: '配置',
                    type: 2,
                    area: area,
                    // skin: 'layui-layer-win10',
                    skin: 'layui-layer-molv',
                    content: '?action=setting_page&tpl=' + data.tplfile,
                    fixed: false, // 不固定
                    scrollbar: false,
                    maxmin: true,
                    shadeClose: true,
                    success: function(layero, index, that){
                    }
                });
            }
        });

        // 触发排序事件
        table.on('sort(index)', function(obj){
            console.log(obj.field); // 当前排序的字段名
            console.log(obj.type); // 当前排序类型：desc（降序）、asc（升序）、null（空对象，默认排序）
            console.log(this); // 当前排序的 th 对象

            // 尽管我们的 table 自带排序功能，但并没有请求服务端。
            // 有些时候，你可能需要根据当前排序的字段，重新向后端发送请求，从而实现服务端排序，如：
            table.reload('index', {
                initSort: obj, // 记录初始排序，如果不设的话，将无法标记表头的排序状态。
                where: { // 请求参数（注意：这里面的参数可任意定义，并非下面固定的格式）
                    field: obj.field, // 排序字段
                    order: obj.type // 排序方式
                }
            });
        });

        // 触发表格复选框选择
        table.on('checkbox(index)', function(obj){
            var id = obj.config.id;
            var checkData = table.checkStatus(id).data;
            console.log(checkData)
            if(checkData.length == 0){
                $('#toolbar-del').addClass('layui-btn-disabled');
            }else{
                $('#toolbar-del').removeClass('layui-btn-disabled');
            }
        });

        // 分页栏事件
        table.on('pagebar(index)', function(obj){
            alert()
            console.log(obj); // 查看对象所有成员
            console.log(obj.config); // 当前实例的配置信息
            console.log(obj.event); // 属性 lay-event 对应的值
        });


        // 表头自定义元素工具事件 --- 2.8.8+
        table.on('colTool(test)', function(obj){
            var event = obj.event;
            console.log(obj);
            if(event === 'email-tips'){
                layer.alert(layui.util.escape(JSON.stringify(obj.col)), {
                    title: '当前列属性选项'
                });
            }
        });


    });
</script>


<script>
    $("#menu-appearance").attr('class', 'admin-menu-item has-list in');
    $("#menu-appearance .fa-angle-right").attr('class', 'admin-arrow fa fa-angle-right active');
    $("#menu-appearance > .submenu").css('display', 'block');
    $('#menu-template > a').attr('class', 'menu-link active')


</script>
