<?php
/*
Plugin Name: 数据统计
Version: 1.0.0
Plugin URL:
Description: 在后台首页展示数据统计图表
Author: 驳手
Author URL:
Ui: Layui
*/

defined('EM_ROOT') || exit('access denied!');

function adm_home(){
    echo <<<html
<style>
.plugin_adm_home_div .layui-btn.active{
    background: #007c70;
}
</style>
<script src="/content/plugins/adm_home/js/echarts.min.js"></script>

<div class="layui-btn-group plugin_adm_home_div" style="margin-top: 15px; margin-bottom: 8px;">
    <button type="button" class="layui-btn active" data-type="">最近7天</button>
    <button type="button" class="layui-btn " data-type="week">本周</button>
    <button type="button" class="layui-btn" data-type="month">本月</button>
    <button type="button" class="layui-btn" data-type="year">今年</button>
</div>
<div style="padding: 0px;margin: 0 auto;" class="grid-cols-lg-1 grid-cols-xl-2 grid-gap-12">
    <div id="adm-home-one" style="width: 100%;height:450px;"></div>
    <div id="adm-home-two" style="width: 100%;height:450px;"></div>
</div>

<script type="text/javascript">
    // 基于准备好的dom，初始化echarts实例
    var admHomeOne = echarts.init(document.getElementById('adm-home-one'));
    // 指定图表的配置项和数据
    var admHomeOneOption = {
    // 设置图表整体背景色
        backgroundColor: '#fff',
        
        grid: {
            top: 80,    // 上边距（默认约 60px，调小后更紧凑）
            right: 30,  // 右边距
            bottom: 20, // 下边距
            left: 30,   // 左边距（需预留坐标轴文字空间，避免被截断）
            containLabel: true // 确保边距包含坐标轴文字，防止文字溢出
        },
        legend: {
            top: 30, // 放在顶部（可选值：'top'/'bottom'/'left'/'right'，或具体像素如 10）
            left: 'center', // 水平居中（可选：'left'/'center'/'right'，或具体像素）
            orient: 'horizontal', // 水平排列（默认，适合顶部展示）
        },
        tooltip: {
            trigger: 'axis', // 针对坐标轴触发（折线图常用）
            axisPointer: {
                type: 'line' // 鼠标悬停时的指示线样式（line/shadow/cross 等）
            },
        },
        xAxis: {
          type: 'category',
          boundaryGap: false,
          data: []
          
        },
        yAxis: {
          type: 'value',
          axisLabel: {
               margin: 15, // 文字与轴线的距离（增大此值，让文字更靠右）
          },
        },
        series: [{
          data: [],
          type: 'line',
          name: '销售额',
          areaStyle: { color: '#16baaa' },
          lineStyle: { color: '#16baaa' },
          itemStyle: { color: '#16baaa' }
        },{
          data: [],
          type: 'line',
          name: '利润',
          areaStyle: { color: '#1e9fff' },
          lineStyle: { color: '#1e9fff' },
          itemStyle: { color: '#1e9fff' }
        }]
    };
    
    // 使用刚指定的配置项和数据显示图表。
    admHomeOne.setOption(admHomeOneOption);
    
    // 基于准备好的dom，初始化echarts实例
    var admHomeTwo = echarts.init(document.getElementById('adm-home-two'));
    // 指定图表的配置项和数据
    var admHomeTwoOption = {
    // 设置图表整体背景色
    backgroundColor: '#fff',
    
    grid: {
      top: 80,    // 上边距（默认约 60px，调小后更紧凑）
      right: 30,  // 右边距
      bottom: 20, // 下边距
      left: 30,   // 左边距（需预留坐标轴文字空间，避免被截断）
      containLabel: true // 确保边距包含坐标轴文字，防止文字溢出
    },
    legend: {
      top: 30, // 放在顶部（可选值：'top'/'bottom'/'left'/'right'，或具体像素如 10）
      left: 'center', // 水平居中（可选：'left'/'center'/'right'，或具体像素）
      orient: 'horizontal', // 水平排列（默认，适合顶部展示）
    },
    tooltip: {
      trigger: 'axis', // 针对坐标轴触发（折线图常用）
      axisPointer: {
          type: 'line' // 鼠标悬停时的指示线样式（line/shadow/cross 等）
      },
    },
    xAxis: {
      type: 'category',
      boundaryGap: false,
      data: []
    },
    yAxis: {
      type: 'value',
      axisLabel: {
           margin: 50, // 文字与轴线的距离（增大此值，让文字更靠右）
      },
    },
    series: [{
      data: [],
      type: 'bar',
      name: '订单数量',
      areaStyle: { color: '#16baaa' },
      lineStyle: { color: '#16baaa' },
      itemStyle: { color: '#16baaa' }
    },{
      data: [],
      type: 'bar',
      name: '下单用户',
      areaStyle: { color: '#1e9fff' },
      lineStyle: { color: '#1e9fff' },
      itemStyle: { color: '#1e9fff' }
    }]
    };
    
    // 使用刚指定的配置项和数据显示图表。
    admHomeTwo.setOption(admHomeTwoOption);
    
    function plugin_adm_home_data(type = ""){
        $.get("/?plugin=adm_home&type=" + type, function(e){
            console.log(e)
            admHomeOneOption.xAxis.data = e.data.oneTitle;
            admHomeTwoOption.xAxis.data = e.data.oneTitle;
            admHomeOneOption.series[0].data = e.data.oneValue[0];
            admHomeOneOption.series[1].data = e.data.oneValue[1];
            admHomeOne.setOption(admHomeOneOption);
            
            admHomeTwoOption.series[0].data = e.data.twoValue[0];
            admHomeTwoOption.series[1].data = e.data.twoValue[1];
            admHomeTwo.setOption(admHomeTwoOption);
        }, "json");
    }
    
    setTimeout(function(){
        plugin_adm_home_data()
    }, 100);
    
    $('.plugin_adm_home_div .layui-btn').click(function(){
        $('.plugin_adm_home_div .layui-btn').removeClass('active');
        $(this).addClass('active');
        plugin_adm_home_data($(this).data('type'));
    })
    
    </script>

html;

}

addAction('adm_main_content', 'adm_home');
