<?php
/**
 * register check
 * @package EMLOG
 * @link https://www.emlog.net
 */

class Register {

    const EMKEY_LEN = 32;

    public static function isRegLocal() {

        $db = Database::getInstance();
        $db_prefix = DB_PREFIX;
        $domain = getDomain();
        $sql = "select * from {$db_prefix}authorization where domain='{$domain}'";
        $res = $db->once_fetch_array($sql);

        if(empty($res) || strlen($res['emkey']) != self::EMKEY_LEN){
            return false;
        }
        return true;

    }

    public static function getRegType() {
        $db = Database::getInstance();
        $db_prefix = DB_PREFIX;
        $domain = getDomain();
        $sql = "select * from {$db_prefix}authorization where domain='{$domain}'";
        $res = $db->once_fetch_array($sql);
//        d($res);die;
        return isset($res['type']) ? $res['type'] : 0;
    }

    public static function isRegServer() {
        $db = Database::getInstance();
        $db_prefix = DB_PREFIX;
        $domain = getDomain();
        $sql = "select * from {$db_prefix}authorization where domain='{$domain}'";
        $res = $db->once_fetch_array($sql);
        return empty($res) ? false : self::verifyEmKey($res['emkey']);
    }

    public static function doReg($emkey) {
        if (empty($emkey)) {
            return ['code' => 400, 'msg' => '请填写授权码'];
        }

        if (strlen($emkey) !== self::EMKEY_LEN) {
            return ['code' => 400, 'msg' => '授权码错误，请检查'];
        }

        $emcurl = new EmCurl();
        $emcurl->setPost(['emkey' => $emkey]);
        $emcurl->request(SERVICE_HOST . '/api/proauth/register');

        $res = $emcurl->getRespone();


        if ($emcurl->getHttpStatus() !== 200) {
            return ['code' => 400, 'msg' => '授权码验证失败，请重试'];
        }
        $response = $emcurl->getRespone();
        $response = json_decode($response, 1);
        if ($response['code'] !== 1) {
            self::clean($emkey);
            return ['code' => 400, 'msg' => $response['msg']];
        }

        return ['code' => 200, 'msg' => 'success', 'data' => $response['data']['type']];

    }

    public static function verifyEmKey($emkey) {
        if (strlen($emkey) !== self::EMKEY_LEN) {
            return false;
        }

        $emcurl = new EmCurl();
        $emcurl->setPost(['emkey' => $emkey]);
        $emcurl->request(SERVICE_HOST . '/api/proauth/verify');

        if ($emcurl->getHttpStatus() !== 200) {
            return false;
        }
        $response = $emcurl->getRespone();
        $response = json_decode($response, 1);
        if ($response['code'] !== 1) {
            self::clean($emkey);
            return false;
        }

        return $response;
    }

    public static function verifyDownload($source) {
        $db = Database::getInstance();
        $db_prefix = DB_PREFIX;
        $domain = getDomain();
        $sql = "select * from {$db_prefix}authorization where domain='{$domain}'";
        $res = $db->once_fetch_array($sql);
        $emkey =  empty($res) ? false : $res['emkey'];


        $emcurl = new EmCurl();
        $emcurl->setPost(['emkey' => $emkey]);
        $emcurl->request(SERVICE_HOST . '/api/store/register?plugin=' . $source);

//        echo $emkey;die;
        $res = $emcurl->getRespone();

//        d($res);die;

        if ($emcurl->getHttpStatus() === 403) {
            self::clean($emkey);
            return false;
        } elseif ($emcurl->getHttpStatus() !== 200) {
            return false;
        }
        return true;
    }

    public static function clean($emkey) {
        $db = Database::getInstance();
        $db_prefix = DB_PREFIX;
        $sql = "DELETE FROM `{$db_prefix}authorization` WHERE `emkey` = '{$emkey}'";
        $db->query($sql);

    }

}
